<?php

define('FPDF_FONTPATH','../fpdf/font/');
require('../fpdf/fpdf.php');

$pdf = new FPDF();
$pdf->AddPage();
$pdf->AddFont('THSarabunNew_b','B','THSarabunNew_b.php');
$pdf->AddFont('THSarabunNew_bi','I','THSarabunNew_bi.php');
$pdf->AddFont('THSarabunNew','','THSarabunNew.php');

$pdf->SetFont('THSarabunNew','','12');

$description='LoremipsumdolorsitametconsecteturadipisicingelitEummagnam,architectooditblanditiisearumhic!Non,inciduntut.Facilis,dolorem,sedrecusandaebeataeidadquiaquibusdampossimusfugiatLoremipsumdolorsitamet,consecteturadipisicingelit.Eummagnam,architectooditblanditiisearumhic!Non,inciduntut.Facilis,dolorem,sedrecusandaebeataeidadquiaquibusdampossimusfugiat';
$desc="สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี สวัสดี";
$column_width=60;//=>ตัวอักษรภาษาไทย 22 ตัว
$len=strlen($desc);

$line1=substr($desc,0,$column_width);
$line2=substr($desc,$column_width,$column_width);
$line3=substr($desc,($column_width*2),$column_width);
$line4=substr($desc,($column_width*3),255);

$pdf->Cell(100,5,iconv('UTF-8','TIS-620',''),'TBRL',1);
//กล่องขนาด 69 บรรจุตัวอักษรภาษาอังกฤษ 50 ตัว กล่อง:ตัวอักษร => 1.38 ~ 1.4
$pdf->Cell(69,5,iconv('UTF-8','TIS-620',substr($description,0,50)),'TBRL',1);
//ถ้าต้องการใส่ตัวอักษร 60 ตัว ต้องใช้กล่องขนาด = 82.8(83)
$pdf->Cell(83+2,5,iconv('UTF-8','TIS-620',substr($description,0,60)),'TBRL',1);
//ถ้าต้องการใส่ตัวอักษร 80 ตัว ต้องใช้กล่องขนาด = 110.4(111)
$pdf->Cell(111+2,5,iconv('UTF-8','TIS-620',substr($description,0,80)),'TBRL',1);
//และถ้าใชอัตราส่วน 1.4(แทน 1.38) ถ้าต้องการใส่ตัวอักษร 80 ตัว ต้องใช้กล่องขนาด = 112
$pdf->Cell(112,5,iconv('UTF-8','TIS-620',substr($description,0,80)),'TBRL',1);
//และถ้าใชอัตราส่วน 1.3825(แทน 1.38) ถ้าต้องการใส่ตัวอักษร 80 ตัว ต้องใช้กล่องขนาด = 110.60
$pdf->Cell(110.6,5,iconv('UTF-8','TIS-620',substr($description,0,80)),'TBRL',1);
//ถ้าต้องการใส่ตัวอักษร 100 ตัว ต้องใช้กล่องขนาด = 138.25
$pdf->Cell(138.25,5,iconv('UTF-8','TIS-620',substr($description,0,100)),'TBRL',1);

//*** ค่าอัตราส่วนที่พอจะประมาณเบื้องต้นควรใช้ตัวเลข 1.3825(สำหรับภาษาอังกฤษ) ***
//*** THSarabunNew 12 ***/
$pdf->Cell(10,5,iconv('UTF-8','TIS-620',''),0,1);
		
$pdf->Cell(100,5,iconv('UTF-8','TIS-620',''),'TBRL',1);
//กล่องขนาด 25 บรรจุตัวอักษรภาษาไทย 22 ตัว กล่อง:ตัวอักษร => 1.13
$pdf->Cell(25,5,iconv('UTF-8','TIS-620',$line1),'TBRL',1);
//กล่อง:ตัวอักษร 25:22 => 1.13
$pdf->Cell(25,5,iconv('UTF-8','TIS-620',$line2),'TBRL',1);
//กล่อง:ตัวอักษร 25:22 => 1.13
$pdf->Cell(25,5,iconv('UTF-8','TIS-620',$line3),'TBRL',1);
//กล่อง:ตัวอักษร 77:73 => 1.05      
$pdf->Cell(77,5,iconv('UTF-8','TIS-620',$line4),'TBRL',1);
//กล่อง = 25 => ตัวอักษร = 23.809(24)
$pdf->Cell(25,5,iconv('UTF-8','TIS-620',$line4),'TBRL',1);
//กล่องขนาด 26 ถึงจะใส่พอดี
$pdf->Cell(26,5,iconv('UTF-8','TIS-620',$line4),'TBRL',1);

//ตัวอักษรภาษาไทย 69 ตัว ดังนั้น ขนาดกล่อง = 1.13 * 69 = 78
require_once "../functions/stringLenTh.php";
$pdf->Cell(78,5,iconv('UTF-8','TIS-620','กกกกกสสสสสัััันียืดเเเเนนพพพวววงบดำหสส้บนะกมทองงวววววooา้ททดเพะยกดพปแออกำ'),'TBRL',1);
//กล่อง:ตัวอักษร 103:69 => 1.49
$pdf->Cell(103,5,iconv('UTF-8','TIS-620','กกกกกสสสสสัััันียืดเเเเนนพพพวววงบดำหสส้บนะกมทองงวววววooา้ททดเพะยกดพปแออกำ'),'TBRL',1);
$pdf->Cell(26,5,iconv('UTF-8','TIS-620','กกกกกสสสสสัััันียืดเเเเนนพพพวววงบดำหสส้บนะกมทองงวววววooา้ททดเพะยกดพปแออกำ'),'TBRL',1);
//สำหรับภาษาไทยยังสรุปความสัมพันธ์ระหว่างกล่องกับตัวอักษรที่บบรจุในกล่องไม่ได้ ขึ้นอยู่กับสระ และวรรณยุค
$pdf->Output();
?>